<?php
require_once 'database.php';

$start_date = date('Y-m-d');
$end_date = date('Y-m-d');

echo "Checking for date: $start_date<br>";

// Check 1: Raw Count
$stmt = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) BETWEEN '$start_date' AND '$end_date'");
echo "Count Taken Today: " . $stmt->fetchColumn() . "<br>";

// Check 2: Raw Values
$stmt = $pdo->query("SELECT id, total_fee, discount, (total_fee - COALESCE(discount, 0)) as net FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) BETWEEN '$start_date' AND '$end_date'");
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

echo "<pre>";
print_r($rows);
echo "</pre>";

// Check 3: Sum Query
$stmt = $pdo->query("SELECT SUM(total_fee - COALESCE(discount, 0)) FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) BETWEEN '$start_date' AND '$end_date'");
echo "Sum Result: " . var_export($stmt->fetchColumn(), true) . "<br>";
?>
