<?php
require_once 'database.php';

try {
    // 1. Insert Dummy Service Order (Status: Taken, Today)
    $stmt = $pdo->prepare("INSERT INTO service_orders 
        (ticket_number, customer_id, device_name, complaint, physical_condition, status, technician_id, cost_estimation, total_fee, discount, down_payment, created_at, updated_at, payment_method) 
        VALUES 
        (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, NOW(), NOW(), ?)");
    
    $ticket = 'TEST-' . date('Ymd-His');
    $stmt->execute([
        $ticket, 
        1, // Customer ID
        'Test Device', 
        'Test Complaint', 
        'Mulus', 
        'Taken', 
        1, // Technician ID
        150000, 
        150000, 
        10000, // Discount
        0, 
        'Cash'
    ]);
    
    $service_id = $pdo->lastInsertId();

    // 2. Insert Dummy Sparepart Usage
    $stmt = $pdo->prepare("INSERT INTO service_parts (service_order_id, sparepart_id, qty, price, total) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$service_id, 1, 1, 50000, 50000]); // Assume sparepart ID 1 exists
    
    echo "Dummy data inserted successfully. Ticket: $ticket";

} catch (PDOException $e) {
    echo "Error: " . $e->getMessage();
}
?>
