<?php
require_once 'config/database.php';

echo "--- DEBUT DEBUG ---\n";

// 1. Pending
$stmt = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE status = 'Pending'");
echo "Pending Count: " . $stmt->fetchColumn() . "\n";

// 2. Process
$stmt = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE status IN ('Checking', 'Waiting Approval', 'On Process')");
echo "Process Count: " . $stmt->fetchColumn() . "\n";

// 3. Completed Today
$today = date('Y-m-d');
echo "Today is: $today\n";
$stmt = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE status = 'Completed' AND DATE(updated_at) = '$today'");
echo "Completed (Today): " . $stmt->fetchColumn() . "\n";

// 3b. Completed Total (for comparison)
$stmt = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE status = 'Completed'");
echo "Completed (All Time): " . $stmt->fetchColumn() . "\n";

// 4. Income Today
$stmt = $pdo->query("SELECT SUM(total_fee) FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) = '$today'");
echo "Income (Today): " . ($stmt->fetchColumn() ?: 0) . "\n";

// 5. All Statuses Breakdown
echo "\n--- STATUS BREAKDOWN ---\n";
$stmt = $pdo->query("SELECT status, COUNT(*) as c, MAX(updated_at) as last_update FROM service_orders GROUP BY status");
foreach ($stmt->fetchAll(PDO::FETCH_ASSOC) as $row) {
    echo "{$row['status']}: {$row['c']} (Last Update: {$row['last_update']})\n";
}
?>
