<?php
require_once '../../config/database.php';

// Date Range Filter
$start_date = $_GET['start_date'] ?? date('Y-m-d');
$end_date = $_GET['end_date'] ?? date('Y-m-d');

// 1. Service Stats
$stmt = $pdo->prepare("SELECT COUNT(*) FROM service_orders WHERE DATE(created_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$total_received = $stmt->fetchColumn();

$stmt = $pdo->prepare("SELECT COUNT(*) FROM service_orders WHERE status = 'Completed' AND DATE(updated_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$total_completed = $stmt->fetchColumn();

$stmt = $pdo->prepare("SELECT COUNT(*) FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$total_taken = $stmt->fetchColumn();

// Total Claims
$stmt = $pdo->prepare("SELECT COUNT(*) FROM service_orders WHERE ticket_number LIKE 'WR-%' AND DATE(created_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$total_claims = $stmt->fetchColumn();

// 2. Financial Stats
$stmt = $pdo->prepare("SELECT SUM(total_fee) FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) BETWEEN ? AND ?");
$stmt->execute([$start_date, $end_date]);
$gross_income = $stmt->fetchColumn() ?: 0;

// Calculate Modal (Spareparts used in Taken services)
$query_modal = "SELECT SUM(sp.qty * s.buy_price) 
                FROM service_parts sp 
                JOIN spareparts s ON sp.sparepart_id = s.id 
                JOIN service_orders so ON sp.service_order_id = so.id 
                WHERE so.status = 'Taken' AND DATE(so.updated_at) BETWEEN ? AND ?";
$stmt = $pdo->prepare($query_modal);
$stmt->execute([$start_date, $end_date]);
$total_modal = $stmt->fetchColumn() ?: 0;

$net_profit = $gross_income - $total_modal;

// 3. List of Transactions
$stmt = $pdo->prepare("SELECT * FROM service_orders WHERE status = 'Taken' AND DATE(updated_at) BETWEEN ? AND ? ORDER BY updated_at DESC");
$stmt->execute([$start_date, $end_date]);
$transactions = $stmt->fetchAll();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Laporan Service HP</title>
    <link rel="stylesheet" href="../../assets/css/print_report.css">
    <style>
        /* Force visibility for this dedicated print page */
        body { visibility: visible !important; margin: 20px; }
        .print-header, .print-signature, .alert, table { display: block !important; visibility: visible !important; }
        .d-print-none { display: none !important; }
        
        /* Layout overrides for dedicated page to match print_report.css expectations */
        .summary-grid {
            display: grid;
            grid-template-columns: repeat(5, 1fr);
            gap: 10px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body onload="window.print()">

<div class="report-card">
    <div class="print-header" style="text-align: center; margin-bottom: 2rem;">
        <div style="border-bottom: 3px double #000; padding-bottom: 15px; margin-bottom: 20px;">
            <h1 style="margin: 0; font-size: 20pt; font-weight: bold; text-transform: uppercase; letter-spacing: 2px;">MAHKOTA SERVICE CENTRE</h1>
            <p style="margin: 5px 0; font-size: 11pt;">Jl. Raya Utama No. 99, Pusat Kota - Indonesia</p>
            <p style="margin: 0; font-size: 11pt;">Telp/WA: 0812-3456-7890 | Email: admin@mahkotaservice.com</p>
        </div>
        
        <h3 style="margin: 0; text-transform: uppercase; text-decoration: underline;">LAPORAN KEUANGAN & SERVICE</h3>
        <p style="margin: 5px 0; font-style: italic;">Periode: <?php echo date('d F Y', strtotime($start_date)); ?> s.d <?php echo date('d F Y', strtotime($end_date)); ?></p>
    </div>

    <!-- Summary Cards -->
    <div class="summary-grid">
        <div class="alert">
            <h4><?php echo $total_received; ?></h4>
            <small>Service Masuk</small>
        </div>
        <div class="alert">
            <h4><?php echo $total_completed; ?></h4>
            <small>Selesai</small>
        </div>
        <div class="alert">
            <h4>Rp <?php echo number_format($gross_income, 0, ',', '.'); ?></h4>
            <small>Omset (Gross)</small>
        </div>
        <div class="alert">
            <h4>Rp <?php echo number_format($net_profit, 0, ',', '.'); ?></h4>
            <small>Profit Bersih</small>
        </div>
        <div class="alert">
            <h4><?php echo $total_claims; ?></h4>
            <small>Klaim Garansi</small>
        </div>
    </div>

    <!-- Transaction Table -->
    <h3 style="font-family: 'Times New Roman', serif; text-transform: uppercase; font-size: 12pt; margin-bottom: 10px;">Rincian Transaksi Selesai:</h3>
    <table>
        <thead>
            <tr>
                <th>Tiket</th>
                <th>Perangkat</th>
                <th>Kerusakan</th>
                <th>Total Biaya</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($transactions as $t): ?>
            <tr>
                <td><?php echo $t['ticket_number']; ?></td>
                <td><?php echo $t['device_name']; ?></td>
                <td><?php echo $t['complaint']; ?></td>
                <td>Rp <?php echo number_format($t['total_fee'], 0, ',', '.'); ?></td>
            </tr>
            <?php endforeach; ?>
            <?php if (count($transactions) == 0): ?>
            <tr><td colspan="4" class="text-center">Belum ada transaksi selesai.</td></tr>
            <?php endif; ?>
        </tbody>
        <tfoot>
            <tr style="font-weight: bold;">
                <td colspan="3" style="text-align: right; border-bottom: none !important;">Total Omset</td>
                <td style="text-align: right; border-bottom: none !important;">Rp <?php echo number_format($gross_income, 0, ',', '.'); ?></td>
            </tr>
        </tfoot>
    </table>

    <!-- Signature Section -->
    <div class="print-signature" style="margin-top: 50px;">
        <table style="width: 100%; border: none;">
            <tr style="border: none;">
                <td style="width: 70%; border: none;"></td>
                <td style="width: 30%; text-align: center; border: none;">
                    <p>Kota, <?php echo date('d F Y'); ?></p>
                    <br><br><br>
                    <p style="font-weight: bold; text-decoration: underline;">( .................................... )</p>
                    <p>Admin / Manager</p>
                </td>
            </tr>
        </table>
    </div>
</div>

</body>
</html>
