<?php
session_start();
require_once '../../config/database.php';

if (!isset($_SESSION['user_id']) || $_SESSION['role'] !== 'admin') {
    die("Akses ditolak. Hanya admin yang dapat menghapus data.");
}

$id = $_GET['id'] ?? 0;

if ($id) {
    try {
        $pdo->beginTransaction();
        
        // 1. Kembalikan stok sparepart yang terkait
        $stmt_parts = $pdo->prepare("SELECT sparepart_id, qty FROM service_parts WHERE service_order_id = ?");
        $stmt_parts->execute([$id]);
        $used_parts = $stmt_parts->fetchAll();

        foreach ($used_parts as $up) {
            // Update stok
            $stmt_update = $pdo->prepare("UPDATE spareparts SET stock = stock + ? WHERE id = ?");
            $stmt_update->execute([$up['qty'], $up['sparepart_id']]);

            // Catat history in
            $stmt_hist = $pdo->prepare("INSERT INTO stock_history (sparepart_id, type, qty, notes) VALUES (?, 'in', ?, ?)");
            $stmt_hist->execute([$up['sparepart_id'], $up['qty'], "Pengembalian stok (Tiket ID: $id Dihapus Admin)"]);
        }

        // 2. Hapus dari service_history
        $stmt = $pdo->prepare("DELETE FROM service_history WHERE service_order_id = ?");
        $stmt->execute([$id]);

        // 3. Hapus dari service_parts
        $stmt = $pdo->prepare("DELETE FROM service_parts WHERE service_order_id = ?");
        $stmt->execute([$id]);

        // 4. Hapus dari service_orders
        $stmt = $pdo->prepare("DELETE FROM service_orders WHERE id = ?");
        $stmt->execute([$id]);
        
        $pdo->commit();
        
        $_SESSION['flash_message'] = "Data Servis berhasil dihapus permanen.";
        $_SESSION['flash_type'] = "success";
    } catch (Exception $e) {
        $pdo->rollBack();
        $_SESSION['flash_message'] = "Gagal menghapus data: " . $e->getMessage();
        $_SESSION['flash_type'] = "danger";
    }
}
header("Location: index.php");
exit();
