<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM service_orders WHERE id = ?");
$stmt->execute([$id]);
$service = $stmt->fetch();

if (!$service) {
    die("Data tidak ditemukan.");
}
?>

<div class="card">
    <div class="card-header mb-3">
        <h2>Update Service: <?php echo $service['ticket_number']; ?></h2>
    </div>

    <form action="update.php" method="POST">
        <input type="hidden" name="id" value="<?php echo $service['id']; ?>">
        
        <div class="form-group">
            <label>Status Sekarang</label>
            <select name="status" class="form-control">
                <?php
                $statuses = ['Pending', 'Checking', 'Waiting Approval', 'On Process', 'Completed', 'Cancelled', 'Taken'];
                foreach ($statuses as $st) {
                    $selected = ($st == $service['status']) ? 'selected' : '';
                    echo "<option value='$st' $selected>$st</option>";
                }
                ?>
            </select>
        </div>

        <div class="form-group">
            <label>Update Biaya (Total Fee)</label>
            <input type="number" name="total_fee" class="form-control" value="<?php echo $service['total_fee']; ?>">
            <small class="text-muted">Biaya Jasa + Sparepart (jika ada)</small>
        </div>
        
        <div class="form-group">
            <label>Catatan Baru (Progress / Kendala)</label>
            <textarea name="notes" class="form-control" rows="3" placeholder="Contoh: LCD sudah diganti, menunggu lem kering..."></textarea>
        </div>

        <div class="form-group mb-4" style="background: var(--surface-color); padding: 15px; border-radius: 8px; border: 1px solid var(--border-color);">
            <label style="color: var(--primary-color); font-weight: bold;"><i class="fas fa-shield-alt"></i> Batas Garansi (Opsional)</label>
            <input type="date" name="warranty_end_date" class="form-control" value="<?php echo $service['warranty_end_date'] ? date('Y-m-d', strtotime($service['warranty_end_date'])) : ''; ?>">
            <small class="text-muted">Isi tanggal ini jika servis sudah selesai dan ingin memberikan garansi ke pelanggan.</small>
        </div>

        <button type="submit" class="btn-primary">Simpan Perubahan</button>
        <a href="view.php?id=<?php echo $service['id']; ?>" class="text-decoration-none ms-3" style="color: #6b7280; margin-left: 1rem;">Batal</a>
    </form>
</div>

<?php require_once '../../layouts/footer.php'; ?>
