<?php
session_start();
require_once '../../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $original_id = $_POST['original_service_id'];
    $complaint = trim($_POST['complaint']);
    $claim_parts = $_POST['claim_parts'] ?? [];

    try {
        $pdo->beginTransaction();

        // 1. Ambil data tiket asli
        $stmt = $pdo->prepare("SELECT * FROM service_orders WHERE id = ?");
        $stmt->execute([$original_id]);
        $old_service = $stmt->fetch();

        if (!$old_service) {
            throw new Exception("Tiket asli tidak ditemukan.");
        }

        // 2. Generate Nomor Tiket Klaim Garansi Baru (Misal: WR-20231015-001)
        $month = date('Ym');
        $stmt_count = $pdo->query("SELECT COUNT(*) FROM service_orders WHERE ticket_number LIKE 'WR-$month%'");
        $count = $stmt_count->fetchColumn();
        $new_ticket = "WR-" . $month . "-" . str_pad($count + 1, 3, '0', STR_PAD_LEFT);

        // 3. Insert Tiket Service Baru (Rp 0)
        $stmt_new = $pdo->prepare("INSERT INTO service_orders (ticket_number, customer_id, device_name, complaint, physical_condition, technician_id, status, cost_estimation, total_fee, down_payment, warranty_end_date) 
                                   VALUES (?, ?, ?, ?, ?, ?, 'Completed', 0, 0, 0, ?)");
        
        $new_complaint = "KLAIM GARANSI (Ref Tiket: {$old_service['ticket_number']})\n\n" . $complaint;
        
        $stmt_new->execute([
            $new_ticket, 
            $old_service['customer_id'], 
            $old_service['device_name'], 
            $new_complaint, 
            $old_service['physical_condition'], 
            $_SESSION['user_id'] ?? $old_service['technician_id'], // current user or old tech
            $old_service['warranty_end_date'] // Sisa garansi? Atau garansi baru? Kita keep end_date sama.
        ]);
        
        $new_service_id = $pdo->lastInsertId();

        // Insert Status History
        $stmt_hist = $pdo->prepare("INSERT INTO service_history (service_order_id, status_old, status_new, notes, user_id) VALUES (?, NULL, 'Completed', 'Tiket Klaim Garansi Dibuat', ?)");
        $stmt_hist->execute([$new_service_id, $_SESSION['user_id'] ?? NULL]);

        // 4. Proses Part yang Ditukar
        if (!empty($claim_parts)) {
            foreach ($claim_parts as $part_id) {
                // Ambil info part
                $stmt_part = $pdo->prepare("SELECT stock, defect_stock, name FROM spareparts WHERE id = ? FOR UPDATE");
                $stmt_part->execute([$part_id]);
                $part_info = $stmt_part->fetch();

                if ($part_info['stock'] < 1) {
                    throw new Exception("Stok untuk sparepart {$part_info['name']} habis (0). Tidak bisa melakukan penukaran klaim garansi.");
                }

                // A. Masukkan ke service_parts (Harga 0)
                $stmt_service_part = $pdo->prepare("INSERT INTO service_parts (service_order_id, sparepart_id, qty, price, total) VALUES (?, ?, 1, 0, 0)");
                $stmt_service_part->execute([$new_service_id, $part_id]);

                // B. Kurangi Stok Baru
                $new_stock = $part_info['stock'] - 1;
                // C. Tambahkan Stok Cacat
                $new_defect = $part_info['defect_stock'] + 1;
                
                $stmt_update_stock = $pdo->prepare("UPDATE spareparts SET stock = ?, defect_stock = ? WHERE id = ?");
                $stmt_update_stock->execute([$new_stock, $new_defect, $part_id]);

                // D. Catat Riwayat Stok Keluar (Barang Baru)
                $stmt_hist_out = $pdo->prepare("INSERT INTO stock_history (sparepart_id, type, qty, notes) VALUES (?, 'out', 1, ?)");
                $stmt_hist_out->execute([$part_id, "Tukar part (Keluar Baru) - Klaim Garansi Tiket: $new_ticket"]);

                // E. Catat Riwayat Stok Masuk Cacat (Return Defect)
                $stmt_hist_in = $pdo->prepare("INSERT INTO stock_history (sparepart_id, type, qty, notes) VALUES (?, 'return_defect', 1, ?)");
                $stmt_hist_in->execute([$part_id, "Retur cacat (Masuk Rusak) - Klaim Garansi Ref: {$old_service['ticket_number']}"]);
            }
        }

        $pdo->commit();

        $_SESSION['flash_message'] = "Klaim Garansi Berhasil Diproses! Tiket baru: $new_ticket";
        $_SESSION['flash_type'] = "success";
        header("Location: view.php?id=$new_service_id");
        exit();

    } catch (Exception $e) {
        $pdo->rollBack();
        die("Error: " . $e->getMessage());
    }
} else {
    header("Location: index.php");
    exit();
}
