<?php
require_once '../../config/database.php';

$id = $_GET['id'] ?? 0;
// Fetch Service & Customer
$stmt = $pdo->prepare("SELECT so.*, c.name as customer_name, c.phone as customer_phone, c.address as customer_address 
                       FROM service_orders so 
                       JOIN customers c ON so.customer_id = c.id 
                       WHERE so.id = ?");
$stmt->execute([$id]);
$service = $stmt->fetch();

if (!$service) die("Data tidak ditemukan.");

// Fetch Settings
$stmt_set = $pdo->query("SELECT * FROM settings WHERE id = 1");
$setting = $stmt_set->fetch();
$store_name = $setting['store_name'] ?? 'Mahkota Service';
$store_address = $setting['store_address'] ?? 'Jl. Raya Utama';
$store_phone = $setting['store_phone'] ?? '-';
$printer_width = $setting['printer_width'] ?? '80mm';
$store_logo = $setting['store_logo'] ?? '';
$footer_note = $setting['footer_note'] ?? '';

// Font adjustment
$font_size = ($printer_width == '58mm') ? '11px' : '14px';
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tanda Terima - <?php echo $service['ticket_number']; ?></title>
    <link href="https://fonts.googleapis.com/css2?family=Courier+Prime&display=swap" rel="stylesheet">
    <style>
        body {
            font-family: 'Courier Prime', monospace;
            font-size: <?php echo $font_size; ?>;
            color: #000;
            background: #fff;
            margin: 0;
            padding: 20px;
        }
        .receipt-box {
            max-width: <?php echo $printer_width; ?>;
            margin: auto;
            border: 1px dashed #ccc;
            padding: <?php echo ($printer_width == '58mm') ? '5px' : '10px'; ?>;
        }
        .header {
            text-align: center;
            border-bottom: 2px dashed #000;
            padding-bottom: 10px;
            margin-bottom: 10px;
        }
        .header h2 { margin: 0; font-size: <?php echo ($printer_width == '58mm') ? '14px' : '18px'; ?>; text-transform: uppercase; }
        .header p { margin: 2px 0; font-size: <?php echo ($printer_width == '58mm') ? '10px' : '12px'; ?>; }
        
        .title {
            text-align: center;
            font-weight: bold;
            margin-bottom: 10px;
            border-bottom: 1px dashed #000;
            padding-bottom: 5px;
            text-transform: uppercase;
        }

        .info { margin-bottom: 10px; }
        .info p { margin: 2px 0; display: flex; justify-content: space-between; }
        
        .details {
            border-top: 1px dashed #000;
            padding-top: 5px;
            margin-bottom: 10px;
        }
        .details p { margin: 2px 0; }
        
        .footer {
            text-align: center;
            margin-top: 20px;
            font-size: <?php echo ($printer_width == '58mm') ? '9px' : '10px'; ?>;
            border-top: 1px dashed #000;
            padding-top: 10px;
        }
        
        .btn-print {
            display: block; width: 100%; padding: 10px; background: #333; color: white;
            text-align: center; text-decoration: none; margin-bottom: 20px; border-radius: 5px;
            font-family: sans-serif;
        }

        @media print {
            body { padding: 0; margin: 0; width: <?php echo $printer_width; ?>; }
            .receipt-box { border: none; width: 100%; max-width: none; padding: 0; }
            .btn-print { display: none; }
            @page { size: <?php echo $printer_width; ?> auto; margin: 0; }
        }
    </style>
</head>
<body>

<div class="receipt-box">
    <a href="#" onclick="window.print()" class="btn-print">Cetak Tanda Terima</a>

    <div class="header">
        <?php if ($store_logo): ?>
            <img src="../../<?php echo $store_logo; ?>" style="max-height: <?php echo ($printer_width == '58mm') ? '40px' : '60px'; ?>; margin-bottom: 5px;">
        <?php endif; ?>
        <h2><?php echo strtoupper($store_name); ?></h2>
        <p><?php echo $store_address; ?></p>
        <p>Telp: <?php echo $store_phone; ?></p>
    </div>

    <div class="title"><?php echo strtoupper($setting['receipt_title'] ?? 'TANDA TERIMA SERVIS'); ?></div>

    <div class="info">
        <p><span>Tgl Masuk:</span> <span><?php echo date('d/m/Y H:i', strtotime($service['created_at'])); ?></span></p>
        <p><span>Tiket:</span> <span><?php echo $service['ticket_number']; ?></span></p>
        <p><span>Cust:</span> <span><?php echo $service['customer_name']; ?></span></p>
        <p><span>Telp:</span> <span><?php echo $service['customer_phone']; ?></span></p>
    </div>

    <div class="details">
        <p><strong>Unit:</strong> <?php echo $service['device_name']; ?></p>
        <p><strong>Keluhan:</strong> Isu <?php echo $service['complaint']; ?></p>
        <p><strong>Kondisi Fisik:</strong> <?php echo $service['physical_condition']; ?></p>
        <p><strong>Kelengkapan:</strong> <?php echo $service['completeness']; ?></p>
        
        <?php if ($service['discount'] > 0): ?>
        <p><strong>Diskon:</strong> Rp <?php echo number_format($service['discount'], 0, ',', '.'); ?></p>
        <?php endif; ?>

        <?php if ($service['down_payment'] > 0): ?>
        <p style="margin-top: 5px;"><strong>DP Tunai:</strong> Rp <?php echo number_format($service['down_payment'], 0, ',', '.'); ?></p>
        <?php endif; ?>
    </div>

    <div class="footer">
        <?php if ($service['warranty_end_date']): ?>
        <div style="margin-bottom: 10px; border-bottom: 1px dashed #000; padding-bottom: 10px;">
            <p style="font-weight: bold; font-size: 1.1em;">INFO GARANSI</p>
            <p>Berlaku s/d: <?php echo date('d M Y', strtotime($service['warranty_end_date'])); ?></p>
            <p style="font-size: 0.9em;">(Syarat: Segel utuh & bukan kesalahan pemakaian)</p>
        </div>
        <?php endif; ?>

        <p><strong>Syarat & Ketentuan:</strong></p>
        <p style="text-align: left; white-space: pre-line;"><?php echo $setting['receipt_policy'] ?? '-'; ?></p>
        <br>
        <p>( <?php echo $service['customer_name']; ?> )</p>
        <p>Tanda Tangan Customer</p>
    </div>
</div>

</body>
</html>
