<?php
session_start();
require_once '../../config/database.php';

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $ticket_number = $_POST['ticket_number'];
    $customer_name = $_POST['customer_name'];
    $customer_phone = $_POST['customer_phone'];
    $customer_address = $_POST['customer_address'];
    $device_name = $_POST['device_name'];
    $complaint = $_POST['complaint'];
    $conditions = isset($_POST['conditions']) ? implode(", ", $_POST['conditions']) : "Mulus / Normal";
    $completeness = $_POST['completeness'] ?? '-';
    $cost_estimation = $_POST['cost_estimation'] ?: 0;
    $down_payment = $_POST['down_payment'] ?: 0;

    try {
        $pdo->beginTransaction();

        // 1. Check or Insert Customer
        // Simple logic: Check by phone, if exists update name/address, else insert
        $stmt = $pdo->prepare("SELECT id FROM customers WHERE phone = ?");
        $stmt->execute([$customer_phone]);
        $customer = $stmt->fetch();

        if ($customer) {
            $customer_id = $customer['id'];
            $stmt = $pdo->prepare("UPDATE customers SET name = ?, address = ? WHERE id = ?");
            $stmt->execute([$customer_name, $customer_address, $customer_id]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO customers (name, phone, address) VALUES (?, ?, ?)");
            $stmt->execute([$customer_name, $customer_phone, $customer_address]);
            $customer_id = $pdo->lastInsertId();
        }

        // 2. Insert Service Order
        $stmt = $pdo->prepare("INSERT INTO service_orders 
            (ticket_number, customer_id, device_name, complaint, physical_condition, completeness, status, cost_estimation, down_payment, created_at) 
            VALUES (?, ?, ?, ?, ?, ?, 'Pending', ?, ?, NOW())");
        $stmt->execute([
            $ticket_number, 
            $customer_id, 
            $device_name, 
            $complaint, 
            $conditions,
            $completeness, 
            $cost_estimation, 
            $down_payment
        ]);
        
        $service_id = $pdo->lastInsertId();

        // 3. Log History
        $user_id = $_SESSION['user_id'];
        $stmt = $pdo->prepare("INSERT INTO service_history (service_order_id, status_old, status_new, notes, user_id) VALUES (?, NULL, 'Pending', 'Service diterima', ?)");
        $stmt->execute([$service_id, $user_id]);

        $pdo->commit();

        $_SESSION['flash_message'] = "Service berhasil diinput! Tiket: $ticket_number";
        $_SESSION['flash_type'] = "success";

        // Redirect to View Page (which will have Print button)
        header("Location: view.php?id=$service_id");
        exit();

    } catch (Exception $e) {
        $pdo->rollBack();
        die("Error: " . $e->getMessage());
    }
}
?>
