<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT so.*, c.name as customer_name, c.phone as customer_phone, c.address as customer_address, u.name as technician_name 
                       FROM service_orders so 
                       JOIN customers c ON so.customer_id = c.id 
                       LEFT JOIN users u ON so.technician_id = u.id 
                       WHERE so.id = ?");
$stmt->execute([$id]);
$service = $stmt->fetch();

if (!$service) {
    die("Data service tidak ditemukan.");
}

// WhatsApp Message Generator
// WhatsApp Message Generator logic
$wa_phone = preg_replace('/^0/', '62', $service['customer_phone']);

// 1. General Status Message
$wa_status_msg = "Halo Kak {$service['customer_name']}, Service HP {$service['device_name']} (Tiket: {$service['ticket_number']}) statusnya sekarang: {$service['status']}. Terima kasih.";
$wa_link_general = "https://wa.me/$wa_phone?text=" . urlencode($wa_status_msg);

// 2. Approval Request Message (Detailing Parts & Cost)
$wa_approval_msg = "Halo Kak {$service['customer_name']},\n\nUpdate cek unit {$service['device_name']} (Tiket: {$service['ticket_number']}).\n\n";
if (!empty($service['cost_estimation']) && $service['cost_estimation'] > 0) {
     $wa_approval_msg .= "Estimasi Jasa: Rp " . number_format($service['cost_estimation'], 0, ',', '.') . "\n";
}
// Fetch parts for message
$stmt_p = $pdo->prepare("SELECT s.name, sp.total FROM service_parts sp JOIN spareparts s ON sp.sparepart_id = s.id WHERE service_order_id = ?");
$stmt_p->execute([$id]);
$parts_list = $stmt_p->fetchAll();

if (count($parts_list) > 0) {
    $wa_approval_msg .= "Ganti Sparepart:\n";
    foreach ($parts_list as $p) {
        $wa_approval_msg .= "- " . $p['name'] . " (Rp " . number_format($p['total'], 0, ',', '.') . ")\n";
    }
}

$wa_approval_msg .= "\nTotal Biaya: Rp " . number_format($service['total_fee'], 0, ',', '.') . "\n";
$wa_approval_msg .= "Mohon konfirmasinya ya Kak apakah boleh dikerjakan? Terima kasih.";
$wa_link_approval = "https://wa.me/$wa_phone?text=" . urlencode($wa_approval_msg);

// Get History
$stmt_hist = $pdo->prepare("SELECT sh.*, u.name as user_name FROM service_history sh JOIN users u ON sh.user_id = u.id WHERE sh.service_order_id = ? ORDER BY sh.created_at DESC");
$stmt_hist->execute([$id]);
$histories = $stmt_hist->fetchAll();
?>

<div class="row grid-3" style="align-items: start;">
    <!-- Main Detail -->
    <div style="grid-column: span 2;">
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-center gap-2 flex-wrap">
                    <h2>Detail Service: <?php echo $service['ticket_number']; ?></h2>
                    <span class="badge" style="background: var(--primary-light); color: var(--primary-dark);"><?php echo $service['status']; ?></span>
                </div>
            </div>

            <div class="table-responsive">
                <table class="table">
                    <tr>
                        <th width="30%">Nama Customer</th>
                        <td><?php echo $service['customer_name']; ?></td>
                    </tr>
                    <tr>
                        <th>No HP / WA</th>
                        <td>
                            <?php echo $service['customer_phone']; ?> 
                            
                            <div class="d-flex gap-2 flex-wrap mt-3">
                                <!-- General Update -->
                                <a href="<?php echo $wa_link_general; ?>" target="_blank" class="btn-primary btn-success" style="padding: 0.4rem 0.8rem; font-size: 0.8rem;">
                                    <i class="fab fa-whatsapp"></i> Update Status
                                </a>
    
                                <!-- Confirmation / Approval Request -->
                                <?php if ($service['status'] == 'Checking' || $service['status'] == 'Waiting Approval'): ?>
                                <a href="<?php echo $wa_link_approval; ?>" target="_blank" class="btn-primary btn-warning" style="padding: 0.4rem 0.8rem; font-size: 0.8rem;">
                                    <i class="fab fa-whatsapp"></i> Minta Persetujuan (Biaya)
                                </a>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>
                    <tr>
                        <th>Perangkat</th>
                        <td><?php echo $service['device_name']; ?></td>
                    </tr>
                    <tr>
                        <th>Keluhan</th>
                        <td><?php echo nl2br($service['complaint']); ?></td>
                    </tr>
                    <tr>
                        <th>Kondisi Fisik</th>
                        <td><?php echo $service['physical_condition']; ?></td>
                    </tr>
                    <tr>
                        <th>Kelengkapan</th>
                        <td><?php echo $service['completeness'] ?? '-'; ?></td>
                    </tr>
                    <tr>
                        <th>Estimasi Biaya</th>
                        <td>Rp <?php echo number_format($service['cost_estimation'], 0, ',', '.'); ?></td>
                    </tr>
                    <tr>
                        <th>DP (Uang Muka)</th>
                        <td>Rp <?php echo number_format($service['down_payment'], 0, ',', '.'); ?></td>
                    </tr>

                    <tr style="background: #fdf2f8;">
                        <th>Total Biaya Akhir</th>
                        <td style="font-size: 1.2rem; font-weight: bold; color: #db2777;">Rp <?php echo number_format($service['total_fee'], 0, ',', '.'); ?></td>
                    </tr>
                    <?php if ((isset($service['discount']) && $service['discount'] > 0)): ?>
                    <tr style="background: #ecfdf5;">
                        <th>Diskon / Potongan</th>
                        <td style="font-size: 1.1rem; font-weight: bold; color: #059669;">- Rp <?php echo number_format($service['discount'], 0, ',', '.'); ?></td>
                    </tr>
                    <tr style="background: #fff7ed;">
                        <th>Total Setelah Diskon</th>
                        <td style="font-size: 1.2rem; font-weight: bold; color: #ea580c;">Rp <?php echo number_format($service['total_fee'] - $service['discount'], 0, ',', '.'); ?></td>
                    </tr>
                    <?php endif; ?>
                    <?php if ($service['warranty_end_date']): ?>
                    <tr>
                        <th>Garansi Berakhir</th>
                        <td>
                            <?php 
                            $end_date = strtotime($service['warranty_end_date'] . ' 23:59:59');
                            $is_expired = time() > $end_date;
                            $color = $is_expired ? 'var(--danger-color)' : 'var(--success-color)';
                            echo "<strong style='color: $color;'>" . date('d F Y', $end_date) . "</strong>";
                            echo $is_expired ? " <span class='badge' style='background: #fee2e2; color: var(--danger-color);'>EXPIRED</span>" : " <span class='badge' style='background: #dcfce7; color: var(--success-color);'>AKTIF</span>";
                            ?>
                        </td>
                    </tr>
                    <?php endif; ?>
                </table>
            </div>
            
            <!-- Sparepart Section -->
            <div class="mb-4 p-3" style="background: #f9fafb; border-radius: 8px; border: 1px solid #e5e7eb;">
                <h4 class="mb-3"><i class="fas fa-microchip"></i> Sparepart yang Digunakan</h4>
                
                <?php
                // Fetch used parts
                $stmt_parts = $pdo->prepare("SELECT sp.*, s.name FROM service_parts sp JOIN spareparts s ON sp.sparepart_id = s.id WHERE sp.service_order_id = ?");
                $stmt_parts->execute([$id]);
                $used_parts = $stmt_parts->fetchAll();
                ?>

                <div class="table-responsive">
                    <table class="table table-sm" style="background: white;">
                        <thead>
                            <tr>
                                <th>Nama Sparepart</th>
                                <th>Qty</th>
                                <th>Harga Satuan</th>
                                <th>Total</th>
                                <th width="50">Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($used_parts as $up): ?>
                            <tr>
                                <td><?php echo $up['name']; ?></td>
                                <td><?php echo $up['qty']; ?></td>
                                <td>Rp <?php echo number_format($up['price'], 0, ',', '.'); ?></td>
                                <td>Rp <?php echo number_format($up['total'], 0, ',', '.'); ?></td>
                                <td>
                                    <a href="delete_part.php?id=<?php echo $up['id']; ?>&service_id=<?php echo $id; ?>" class="text-danger" onclick="return confirm('Hapus sparepart ini? Stok akan dikembalikan.')"><i class="fas fa-trash"></i></a>
                                </td>
                            </tr>
                            <?php endforeach; ?>
                            <?php if (count($used_parts) == 0): ?>
                            <tr><td colspan="5" class="text-center text-muted">Belum ada sparepart yang digunakan.</td></tr>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>

                <!-- Add Part Form -->
                <form action="add_part.php" method="POST" class="mt-3 d-flex flex-wrap gap-2 align-center">
                    <input type="hidden" name="service_id" value="<?php echo $id; ?>">
                    <div style="flex: 2; min-width: 200px;">
                        <label style="font-size: 0.85rem;">Pilih Sparepart</label>
                        <select name="sparepart_id" class="form-control" required>
                            <option value="">-- Pilih Barang --</option>
                            <?php
                            $stmt_stock = $pdo->query("SELECT * FROM spareparts WHERE stock > 0 ORDER BY name ASC");
                            while ($row = $stmt_stock->fetch()) {
                                $warranty_text = $row['warranty_days'] > 0 ? " | Garansi: {$row['warranty_days']} Hari" : "";
                                echo "<option value='{$row['id']}'>{$row['name']} (Stok: {$row['stock']} | Rp " . number_format($row['sell_price'], 0, ',', '.') . "{$warranty_text})</option>";
                            }
                            ?>
                        </select>
                    </div>
                    <div style="flex: 1; min-width: 100px;">
                        <label style="font-size: 0.85rem;">Qty</label>
                        <input type="number" name="qty" class="form-control" value="1" min="1" required>
                    </div>
                    <div>
                         <label style="visibility: hidden;">Add</label>
                        <button type="submit" class="btn-primary w-100">+ Tambah</button>
                    </div>
                </form>
            </div>

            <div class="actions d-flex flex-wrap gap-2">
                <!-- Tanda Terima (Modal Trigger) -->
                <button onclick="openReceiptModal(<?php echo $service['id']; ?>)" class="btn-primary" style="background: var(--secondary-color);"><i class="fas fa-print"></i> Tanda Terima</button>

                <button onclick="window.open('print_label.php?id=<?php echo $service['id']; ?>', '_blank', 'width=300,height=300')" class="btn-primary btn-danger"><i class="fas fa-tag"></i> Label</button>
                
                <?php if ($service['status'] == 'Completed'): ?>
                    <button type="button" onclick="document.getElementById('paymentModal').style.display='block'" class="btn-primary btn-success"><i class="fas fa-money-bill-wave"></i> Bayar & Ambil</button>
                <?php elseif ($service['status'] != 'Taken'): ?>
                    <a href="edit.php?id=<?php echo $service['id']; ?>" class="btn-primary btn-warning">Edit / Update Status</a>
                <?php endif; ?>

                <?php 
                $warranty_valid = false;
                if ($service['warranty_end_date']) {
                    date_default_timezone_set('Asia/Jakarta');
                    $end_date_check = strtotime($service['warranty_end_date'] . ' 23:59:59');
                    if (time() <= $end_date_check) {
                        $warranty_valid = true;
                    }
                }
                ?>
                <?php 
                // DEBUG WARANTY:
                // echo "<!-- DEBUG: end_date_raw=" . $service['warranty_end_date'] . ", end_date_check=" . date('Y-m-d H:i:s', $end_date_check) . ", now=" . date('Y-m-d H:i:s') . ", valid=" . ($warranty_valid ? 'true' : 'false') . " -->";
                ?>
                <?php if ($service['status'] == 'Taken' && $warranty_valid): ?>
                    <a href="warranty_claim.php?id=<?php echo $service['id']; ?>" class="btn-primary" style="background: #f59e0b; color: white; border: none; width: 100%; display: block; text-align: center; margin-bottom: 15px; font-size: 1.1rem; padding: 12px; border-radius: 8px; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
                        <i class="fas fa-tools"></i> <strong style="color: white;">Klaim Garansi Sparepart (<?php echo date('d M Y', strtotime($service['warranty_end_date'])); ?>)</strong>
                    </a>
                <?php endif; ?>

                <?php if ($service['status'] == 'Taken'): ?>
                    <div class="alert alert-success w-100 mt-2 mb-2 p-3" style="background: #dcfce7; color: #166534; border-radius: var(--radius-md);">
                        <i class="fas fa-check-circle"></i> <strong>LUNAS</strong> via <?php echo $service['payment_method']; ?>
                    </div>

                    <!-- Invoice & WA Buttons (Only Show When Paid) -->
                    <a href="invoice.php?id=<?php echo $service['id']; ?>" target="_blank" class="btn-primary" style="background: #4b5563;"><i class="fas fa-file-invoice"></i> Cetak Nota</a>
                    
                    <?php
                    // WA Struk Message
                    $wa_struk = "*INVOICE MAHKOTA SERVICE*\n";
                    $wa_struk .= "Tiket: {$service['ticket_number']}\n";
                    $wa_struk .= "Tgl: " . date('d/m/Y') . "\n";
                    $wa_struk .= "--------------------------------\n";
                    $wa_struk .= "Unit: {$service['device_name']}\n";
                    $wa_struk .= "Keluhan: {$service['complaint']}\n";
                    $wa_struk .= "--------------------------------\n";
                    if ($service['cost_estimation'] > 0) {
                        $wa_struk .= "Jasa: Rp " . number_format($service['cost_estimation'], 0, ',', '.') . "\n";
                    }
                    foreach ($used_parts as $up) {
                        $wa_struk .= "{$up['name']} (x{$up['qty']}): Rp " . number_format($up['total'], 0, ',', '.') . "\n";
                    }
                    $wa_struk .= "--------------------------------\n";
                    $wa_struk .= "Total: Rp " . number_format($service['total_fee'], 0, ',', '.') . "\n";
                    if (isset($service['discount']) && $service['discount'] > 0) {
                        $wa_struk .= "Diskon: - Rp " . number_format($service['discount'], 0, ',', '.') . "\n";
                    }
                    $wa_struk .= "DP: - Rp " . number_format($service['down_payment'], 0, ',', '.') . "\n";
                    $total_akhir = $service['total_fee'] - ($service['discount'] ?? 0);
                    $sisa_tagihan_wa = $total_akhir - $service['down_payment'];
                    $wa_struk .= "*SISA: Rp " . number_format($sisa_tagihan_wa, 0, ',', '.') . "*\n";
                    $wa_struk .= "\n[LUNAS via {$service['payment_method']}]\n";
                    $wa_struk .= "--------------------------------\n";
                    $wa_struk .= "Terima kasih atas kepercayaannya 🙏";
                    
                    $link_struk_wa = "https://wa.me/$wa_phone?text=" . urlencode($wa_struk);
                    ?>
                    
                    <a href="<?php echo $link_struk_wa; ?>" target="_blank" class="btn-primary btn-success">
                        <i class="fab fa-whatsapp"></i> Kirim Nota
                    </a>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <!-- Sidebar History -->
    <div> 
        <h3 class="mt-4 mb-3" style="font-size: 1.25rem;">Riwayat Status</h3>
        <ul style="list-style: none; padding: 0;">
            <?php foreach ($histories as $history): ?>
            <li class="card" style="padding: 1rem; margin-bottom: 0.75rem; border-left: 4px solid var(--primary-color);">
                <div class="d-flex justify-between mb-1">
                    <strong><?php echo date('d/m/Y H:i', strtotime($history['created_at'])); ?></strong>
                    <span class="text-muted" style="font-size: 0.85rem;">by <?php echo $history['user_name']; ?></span>
                </div>
                <div>Status: <span class="badge" style="background: var(--primary-light); color: var(--primary-dark);"><?php echo $history['status_new']; ?></span></div>
                <div class="text-muted mt-1" style="font-size: 0.9rem;"><?php echo $history['notes']; ?></div>
            </li>
            <?php endforeach; ?>
        </ul>
    </div>
</div>

<!-- Receipt Modal -->
<div id="receiptModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000; justify-content: center; align-items: center;">
    <div style="background: white; width: 90%; max-width: 500px; height: 90vh; border-radius: 8px; display: flex; flex-direction: column; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1);">
        <div style="padding: 10px 15px; background: #f3f4f6; border-bottom: 1px solid #e5e7eb; display: flex; justify-content: space-between; align-items: center;">
            <h5 style="margin: 0; font-weight: bold;">Cetak Tanda Terima</h5>
            <button onclick="closeReceiptModal()" style="border: none; background: none; font-size: 1.5rem; cursor: pointer;">&times;</button>
        </div>
        <div style="flex: 1; position: relative;">
            <iframe id="receiptFrame" src="" style="width: 100%; height: 100%; border: none;"></iframe>
        </div>
        <div style="padding: 15px; border-top: 1px solid #e5e7eb; text-align: center; background: white;">
            <button onclick="closeReceiptModal()" class="btn-primary" style="background: #ef4444; width: 100%;">Tutup</button>
        </div>
    </div>
</div>

<!-- Payment Modal -->
<div id="paymentModal" style="display: none; position: fixed; top: 0; left: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); z-index: 1000;">
    <div style="background: white; width: 400px; margin: 100px auto; padding: 2rem; border-radius: 8px;">
        <h3>Pembayaran & Pengambilan</h3>
        
        <form action="process_payment.php" method="POST">
            <input type="hidden" name="id" value="<?php echo $service['id']; ?>">
                <?php 
                $sisa_tagihan = $service['total_fee'] - $service['down_payment'];
                ?>
            <!-- Removed fixed final_amount here, will clarify in logic -->
            
                <div class="mb-3">
                    <label>Total Biaya Service</label>
                    <input type="text" class="form-control" value="Rp <?php echo number_format($service['total_fee'], 0, ',', '.'); ?>" readonly>
                </div>
                <div class="mb-3">
                    <label>Sudah Bayar DP</label>
                    <input type="text" class="form-control" value="Rp <?php echo number_format($service['down_payment'], 0, ',', '.'); ?>" readonly style="color: green; font-weight: bold;">
                </div>
                
                <div class="mb-3">
                    <label style="font-weight: bold; color: #d97706;">Diskon / Potongan Harga</label>
                    <input type="text" name="discount" id="discountAmount" class="form-control" onkeyup="formatRupiah(this); calculateChange()" placeholder="0">
                </div>

                <div class="mb-4">
                    <label style="font-weight: bold; font-size: 1.1em;">Sisa Tagihan (Yang Harus Dibayar)</label>
                    <input type="text" id="finalBill" class="form-control" value="Rp <?php echo number_format($sisa_tagihan, 0, ',', '.'); ?>" readonly style="font-weight: bold; font-size: 1.5em; color: #dc2626; border: 2px solid #dc2626; background: #fef2f2;">
                </div>

                <div class="form-group mb-3">
                    <label>Metode Pembayaran Pelunasan</label>
                    <select name="payment_method" id="paymentMethod" class="form-control" required style="font-size: 1.1em;" onchange="togglePaymentFields()">
                        <option value="Cash">Cash / Tunai</option>
                        <option value="Transfer">Transfer Bank</option>
                        <option value="QRIS">QRIS</option>
                    </select>
                </div>

                <!-- Cash Fields -->
                <div id="cashFields">
                    <div class="mb-3">
                        <label>Uang Diterima (Rp)</label>
                        <input type="text" name="received_amount" id="receivedAmount" class="form-control" onkeyup="formatRupiah(this); calculateChange()" placeholder="Contoh: 50.000">
                    </div>
                    <div class="mb-3">
                        <label>Kembalian</label>
                        <input type="text" id="changeAmount" class="form-control" readonly style="font-weight: bold; color: blue;">
                    </div>
                </div>

                <!-- Transfer/QRIS Fields -->
                <div id="refFields" style="display: none;">
                    <div class="mb-3">
                        <label>4 Digit Terakhir Bukti TF / Ref</label>
                        <input type="text" name="ref_number" class="form-control" placeholder="Contoh: 1234" maxlength="4">
                    </div>
                </div>
            
            <div style="display: flex; gap: 10px; margin-top: 20px;">
                <button type="submit" class="btn-primary">Proses Lunas</button>
                <button type="button" onclick="document.getElementById('paymentModal').style.display='none'" class="btn-primary" style="background: #9ca3af;">Batal</button>
            </div>
        </form>
    </div>
</div>

<script>
function openReceiptModal(id) {
    let modal = document.getElementById('receiptModal');
    let iframe = document.getElementById('receiptFrame');
    
    iframe.src = 'receipt.php?id=' + id;
    modal.style.display = 'flex'; // Changed to flex for centering
}

function closeReceiptModal() {
    document.getElementById('receiptModal').style.display = 'none';
    document.getElementById('receiptFrame').src = ''; // Create empty to stop functionality
}

function togglePaymentFields() {
    var method = document.getElementById('paymentMethod').value;
    if (method === 'Cash') {
        document.getElementById('cashFields').style.display = 'block';
        document.getElementById('refFields').style.display = 'none';
        document.getElementById('receivedAmount').required = true;
    } else {
        document.getElementById('cashFields').style.display = 'none';
        document.getElementById('refFields').style.display = 'block';
        document.getElementById('receivedAmount').required = false;
    }
}

function formatRupiah(angka) {
    var value = angka.value.replace(/[^,\d]/g, '').toString();
    var split = value.split(',');
    var sisa = split[0].length % 3;
    var rupiah = split[0].substr(0, sisa);
    var ribuan = split[0].substr(sisa).match(/\d{3}/gi);

    if (ribuan) {
        separator = sisa ? '.' : '';
        rupiah += separator + ribuan.join('.');
    }

    rupiah = split[1] != undefined ? rupiah + ',' + split[1] : rupiah;
    angka.value = rupiah;
}

function calculateChange() {
    var totalFee = <?php echo $service['total_fee']; ?>;
    var downPayment = <?php echo $service['down_payment']; ?>;
    
    // Get Discount
    var rawDiscount = document.getElementById('discountAmount').value.replace(/\./g, '');
    var discount = parseInt(rawDiscount) || 0;
    
    // Calculate Final Bill
    var finalBill = totalFee - downPayment - discount;
    if (finalBill < 0) finalBill = 0; // Prevent negative bill

    // Update Display Final Bill
    document.getElementById('finalBill').value = "Rp " + new Intl.NumberFormat('id-ID').format(finalBill);

    // Calculate Change
    var rawReceived = document.getElementById('receivedAmount').value.replace(/\./g, '');
    var received = parseInt(rawReceived) || 0;
    
    var change = received - finalBill;
    
    if (received && change >= 0) {
        document.getElementById('changeAmount').value = "Rp " + new Intl.NumberFormat('id-ID').format(change);
        document.getElementById('changeAmount').style.color = 'blue';
    } else {
        document.getElementById('changeAmount').value = "Kurang Rp " + new Intl.NumberFormat('id-ID').format(Math.abs(change));
        document.getElementById('changeAmount').style.color = 'red';
    }
}
</script>

<!-- Print Styles (Hidden on Screen) -->
<style>
@media print {
    body * {
        visibility: hidden;
    }
    .card, .card * {
        visibility: visible;
    }
    .card {
        position: absolute;
        left: 0;
        top: 0;
        width: 100%;
        box-shadow: none;
        border: none;
    }
    .actions, .sidebar, .mt-4, #paymentModal {
        display: none !important;
    }
}
</style>

<?php require_once '../../layouts/footer.php'; ?>
