<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

$id = $_GET['id'] ?? 0;

// Fetch Original Ticket
$stmt = $pdo->prepare("SELECT so.*, c.name as customer_name FROM service_orders so JOIN customers c ON so.customer_id = c.id WHERE so.id = ?");
$stmt->execute([$id]);
$service = $stmt->fetch();

if (!$service) die("Tiket tidak ditemukan.");

// Check Warranty Validity
$end_date = strtotime($service['warranty_end_date'] . ' 23:59:59');
if (time() > $end_date) {
    die("Garansi tiket ini sudah habis (Expired).");
}

if ($service['status'] != 'Taken') {
    die("Hanya tiket berstatus 'Taken' (Sudah Diambil) yang bisa diklaim garansi.");
}

// Fetch Parts Used in Original Ticket
$stmt_parts = $pdo->prepare("SELECT sp.*, s.name, s.stock FROM service_parts sp JOIN spareparts s ON sp.sparepart_id = s.id WHERE sp.service_order_id = ?");
$stmt_parts->execute([$id]);
$used_parts = $stmt_parts->fetchAll();
?>

<div class="card" style="max-width: 800px; margin: 0 auto;">
    <div class="card-header mb-4">
        <h2 style="margin: 0;"><i class="fas fa-tools"></i> Form Klaim Garansi</h2>
    </div>

    <div class="alert alert-info mb-4" style="background: #eff6ff; border: 1px solid #bfdbfe; color: #1e40af;">
        <strong>Informasi Tiket Asli:</strong><br>
        Nomor Tiket: <?php echo $service['ticket_number']; ?><br>
        Customer: <?php echo $service['customer_name']; ?><br>
        Perangkat: <?php echo $service['device_name']; ?><br>
        Berlaku Sampai: <?php echo date('d F Y', $end_date); ?>
    </div>

    <form action="process_warranty.php" method="POST">
        <input type="hidden" name="original_service_id" value="<?php echo $service['id']; ?>">
        
        <div class="form-group mb-4">
            <label style="font-weight: bold;">Catatan / Keluhan Klaim Garansi <span class="text-danger">*</span></label>
            <textarea name="complaint" class="form-control" rows="3" required placeholder="Contoh: LCD kembali berkedip/mati..."></textarea>
            <small class="text-muted">Jelaskan kenapa pelanggan melakukan klaim garansi.</small>
        </div>

        <h4 class="mb-3">Pilih Sparepart yang Diretur/Ditukar:</h4>
        <p class="text-muted mb-3" style="font-size: 0.9rem;">Centang barang yang rusak. Tiap barang yang dicentang akan <b>mengurangi stok baru 1 unit</b> (diberikan ke pelanggan) dan <b>menambah stok cacat 1 unit</b> (dikembalikan oleh pelanggan).</p>
        
        <div class="table-responsive mb-4">
            <table class="table">
                <thead>
                    <tr>
                        <th width="50" class="text-center">Pilih</th>
                        <th>Nama Sparepart</th>
                        <th>Qty Awal</th>
                        <th>Sisa Stok Baru di Gudang</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (count($used_parts) > 0): ?>
                        <?php foreach ($used_parts as $part): ?>
                        <tr>
                            <td class="text-center">
                                <input type="checkbox" name="claim_parts[]" value="<?php echo $part['sparepart_id']; ?>" style="width: 20px; height: 20px;">
                            </td>
                            <td><strong><?php echo $part['name']; ?></strong></td>
                            <td><?php echo $part['qty']; ?> pcs</td>
                            <td>
                                <?php if ($part['stock'] > 0): ?>
                                    <span style="color: green;"><?php echo $part['stock']; ?> tersedia</span>
                                <?php else: ?>
                                    <span style="color: red;">Habis (<?php echo $part['stock']; ?>) - Tidak bisa ditukar</span>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="4" class="text-center text-muted">Tidak ada sparepart yang diganti pada servis ini. Klaim garansi mungkin hanya berupa jasa servis ulang.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="d-flex gap-3 mt-4">
            <button type="submit" class="btn-primary" style="background: var(--primary-color);" onclick="return confirm('Proses klaim garansi ini? Pastikan stok baru tersedia untuk ditukar.')">
                Proses Klaim Garansi (Buat Tiket 0 Rupiah)
            </button>
            <a href="view.php?id=<?php echo $service['id']; ?>" class="btn-primary" style="background: #6b7280;">Batal</a>
        </div>
    </form>
</div>

<?php require_once '../../layouts/footer.php'; ?>
