<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

// Only Admin can access
if ($_SESSION['role'] !== 'admin') {
    echo "<script>alert('Akses Ditolak!'); window.location='../../index.php';</script>";
    exit();
}

$success_msg = "";
$error_msg = "";

// Handle Form Submission
if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $store_name = $_POST['store_name'];
    $store_address = $_POST['store_address'];
    $store_phone = $_POST['store_phone'];
    $store_email = $_POST['store_email'];
    $footer_note = $_POST['footer_note'];

    // Handle Logo Upload
    if (isset($_FILES['store_logo']) && $_FILES['store_logo']['error'] == 0) {
        $target_dir = "../../assets/images/";
        if (!file_exists($target_dir)) {
            mkdir($target_dir, 0777, true);
        }
        
        $file_ext = strtolower(pathinfo($_FILES["store_logo"]["name"], PATHINFO_EXTENSION));
        $allowed = ['jpg', 'jpeg', 'png'];
        
        if (in_array($file_ext, $allowed)) {
            $new_filename = "logo." . $file_ext;
            $target_file = $target_dir . $new_filename;
            
            if (move_uploaded_file($_FILES["store_logo"]["tmp_name"], $target_file)) {
                // Save logo path to DB (relative path)
                $logo_path = "assets/images/" . $new_filename;
                $stmt = $pdo->prepare("UPDATE settings SET store_logo = ? WHERE id = 1");
                $stmt->execute([$logo_path]);
            } else {
                $error_msg = "Gagal upload logo.";
            }
        } else {
            $error_msg = "Format logo harus JPG/PNG.";
        }
    }

    $printer_width = $_POST['printer_width'];
    $receipt_title = $_POST['receipt_title'];
    $receipt_policy = $_POST['receipt_policy'];

    try {
        $stmt = $pdo->prepare("UPDATE settings SET store_name=?, store_address=?, store_phone=?, store_email=?, footer_note=?, printer_width=?, receipt_title=?, receipt_policy=?, updated_at=NOW() WHERE id=1");
        $stmt->execute([$store_name, $store_address, $store_phone, $store_email, $footer_note, $printer_width, $receipt_title, $receipt_policy]);
        $success_msg = "Pengaturan berhasil disimpan!";
    } catch (PDOException $e) {
        $error_msg = "Error: " . $e->getMessage();
    }
}

// Fetch Settings
$stmt = $pdo->query("SELECT * FROM settings WHERE id = 1");
$setting = $stmt->fetch();

// Default values if empty
if (!$setting) {
    $pdo->query("INSERT INTO settings (id) VALUES (1)");
    $setting = ['store_name' => '', 'store_address' => '', 'store_phone' => '', 'store_email' => '', 'footer_note' => '', 'store_logo' => ''];
}
?>

<style>
    .settings-grid {
        display: grid;
        grid-template-columns: 240px 1fr 300px;
        gap: 1.5rem;
        align-items: start;
    }
    
    @media (max-width: 992px) {
        .settings-grid {
            grid-template-columns: 1fr;
        }
        .settings-preview {
            display: none; /* Hide preview on tablet/mobile to save space, or move it */
        }
    }

    .menu-item {
        padding: 1rem;
        cursor: pointer;
        border-radius: var(--border-radius);
        margin-bottom: 0.5rem;
        transition: all 0.2s;
        color: var(--text-color);
        font-weight: 500;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }
    .menu-item:hover {
        background: var(--background-color);
        color: var(--primary-color);
    }
    .menu-item.active {
        background: var(--primary-light);
        color: var(--primary-color);
        font-weight: 600;
    }
    
    .tab-section { display: none; animation: fadeIn 0.3s ease-out; }
    .tab-section.active { display: block; }
    
    @keyframes fadeIn {
        from { opacity: 0; transform: translateY(5px); }
        to { opacity: 1; transform: translateY(0); }
    }
</style>

<div class="mb-4">
    <h2 style="margin: 0;"><i class="fas fa-cog"></i> Pengaturan Toko</h2>
</div>

<?php if ($success_msg): ?>
    <div class="alert alert-success mb-4"><?php echo $success_msg; ?></div>
<?php endif; ?>
<?php if ($error_msg): ?>
    <div class="alert alert-danger mb-4"><?php echo $error_msg; ?></div>
<?php endif; ?>

<form method="POST" enctype="multipart/form-data">
    <div class="settings-grid">
        
        <!-- Sidebar Menu -->
        <div class="card p-2">
            <div class="menu-item active" onclick="switchTab('general')">
                <i class="fas fa-store"></i> Informasi Toko
            </div>
            <div class="menu-item" onclick="switchTab('invoice')">
                <i class="fas fa-file-invoice"></i> Nota & Printer
            </div>
            <div class="menu-item" onclick="switchTab('receipt')">
                <i class="fas fa-receipt"></i> Tanda Terima
            </div>
        </div>

        <!-- Form Content -->
        <div class="card">
            
            <!-- Tab General -->
            <div id="tab-general" class="tab-section active">
                <h4 class="mb-4" style="border-bottom: 2px solid var(--border-color); padding-bottom: 10px; color: var(--primary-color);">Informasi Umum</h4>
                
                <div class="form-group mb-3">
                    <label class="form-label">Nama Toko</label>
                    <input type="text" name="store_name" id="storeNameInput" class="form-control" value="<?php echo htmlspecialchars($setting['store_name']); ?>" required oninput="updatePreview()">
                </div>
                <div class="form-group mb-3">
                    <label class="form-label">Alamat Lengkap</label>
                    <textarea name="store_address" id="storeAddressInput" class="form-control" rows="3" oninput="updatePreview()"><?php echo htmlspecialchars($setting['store_address']); ?></textarea>
                </div>
                <div class="form-group mb-3">
                    <label class="form-label">No. Telepon / WA</label>
                    <input type="text" name="store_phone" id="storePhoneInput" class="form-control" value="<?php echo htmlspecialchars($setting['store_phone']); ?>" oninput="updatePreview()">
                </div>
                <div class="form-group mb-3">
                    <label class="form-label">Email (Opsional)</label>
                    <input type="email" name="store_email" class="form-control" value="<?php echo htmlspecialchars($setting['store_email']); ?>">
                </div>
                <div class="form-group mb-3">
                    <label class="form-label">Logo Toko</label>
                    <input type="file" name="store_logo" class="form-control" accept="image/*">
                    <small class="text-muted">Format: JPG/PNG. Ukuran max 2MB.</small>
                </div>
            </div>

            <!-- Tab Invoice -->
            <div id="tab-invoice" class="tab-section">
                <h4 class="mb-4" style="border-bottom: 2px solid var(--border-color); padding-bottom: 10px; color: var(--primary-color);">Pengaturan Nota / Invoice</h4>
                
                <div class="form-group mb-3">
                    <label class="form-label">Ukuran Printer (Thermal)</label>
                    <select name="printer_width" id="printerWidthInput" class="form-control" onchange="updatePreview()">
                        <option value="80mm" <?php echo ($setting['printer_width'] == '80mm') ? 'selected' : ''; ?>>80mm (Standar Toko)</option>
                        <option value="58mm" <?php echo ($setting['printer_width'] == '58mm') ? 'selected' : ''; ?>>58mm (Kecil/Bluetooth)</option>
                    </select>
                     <small class="text-muted">Akan berpengaruh ke ukuran font dan lebar kertas seluruh struk.</small>
                </div>

                <div class="form-group mb-3">
                    <label class="form-label">Catatan Kaki (Footer Note)</label>
                    <textarea name="footer_note" id="footerNoteInput" class="form-control" rows="3" oninput="updatePreview()"><?php echo htmlspecialchars($setting['footer_note']); ?></textarea>
                    <small class="text-muted">Muncul di bagian paling bawah struk nota.</small>
                </div>
            </div>

            <!-- Tab Receipt -->
            <div id="tab-receipt" class="tab-section">
                <h4 class="mb-4" style="border-bottom: 2px solid var(--border-color); padding-bottom: 10px; color: var(--primary-color);">Pengaturan Tanda Terima</h4>
                
                <div class="form-group mb-3">
                    <label class="form-label">Judul Dokumen</label>
                    <input type="text" name="receipt_title" id="receiptTitleInput" class="form-control" value="<?php echo htmlspecialchars($setting['receipt_title'] ?? 'TANDA TERIMA SERVIS'); ?>" oninput="updatePreview()">
                    <small class="text-muted">Contoh: BUKTI SERVICE, TANDA TERIMA, etc.</small>
                </div>
                <div class="form-group mb-3">
                    <label class="form-label">Syarat & Ketentuan (Policy)</label>
                    <textarea name="receipt_policy" id="receiptPolicyInput" class="form-control" rows="6" oninput="updatePreview()"><?php echo htmlspecialchars($setting['receipt_policy']); ?></textarea>
                    <small class="text-muted">Gunakan Enter untuk membuat baris baru (poin-poin).</small>
                </div>
            </div>

            <div class="mt-4 pt-3 text-end" style="border-top: 1px solid var(--border-color);">
                <button type="submit" class="btn-primary" style="padding: 0.8rem 2rem;">
                    <i class="fas fa-save me-2"></i> Simpan Perubahan
                </button>
            </div>

        </div>

        <!-- Preview Pane -->
        <div class="card settings-preview">
            <div class="d-flex justify-between align-center mb-3">
                <h5 style="margin:0;">Live Preview</h5>
                <select id="previewMode" class="form-control" style="width: auto; font-size: 0.85rem; padding: 5px;" onchange="updatePreview()">
                    <option value="invoice">Nota / Invoice</option>
                    <option value="receipt">Tanda Terima</option>
                </select>
            </div>

            <div id="invoicePreview" style="background: white; border: 1px solid #ccc; padding: 10px; font-family: 'Courier Prime', monospace; font-size: 12px; color: black; margin: auto; transition: all 0.3s; box-shadow: 0 2px 4px rgba(0,0,0,0.1);">
                
                <div style="text-align: center; border-bottom: 2px dashed #000; padding-bottom: 10px; margin-bottom: 10px;">
                    <?php if (!empty($setting['store_logo'])): ?>
                        <img src="../../<?php echo $setting['store_logo']; ?>?t=<?php echo time(); ?>" style="max-height: 50px; display: block; margin: 0 auto 5px auto;">
                    <?php endif; ?>
                    <h2 id="prevStoreName" style="margin: 0; font-size: 14pt; font-weight: bold; text-transform: uppercase;">MAHKOTA SERVICE</h2>
                    <p id="prevStoreAddress" style="margin: 2px 0;">Jl. Raya Utama No. 99</p>
                    <p id="prevStorePhone" style="margin: 0;">Telp: 0812-3456-7890</p>
                </div>

                <!-- Receipt Title -->
                <div id="prevReceiptTitle" style="display: none; text-align: center; font-weight: bold; margin-bottom: 10px; border-bottom: 1px dashed #000; padding-bottom: 5px; text-transform: uppercase;">TANDA TERIMA SERVIS</div>

                <!-- Info Area (Invoice) -->
                <div id="invoiceInfo" style="border-bottom: 1px dashed #000; padding-bottom: 5px; margin-bottom: 5px;">
                    <div style="display: flex; justify-content: space-between;"><span>Tiket:</span> <span>SRV-001</span></div>
                    <div style="display: flex; justify-content: space-between;"><span>Tgl:</span> <span><?php echo date('d/m/Y'); ?></span></div>
                    <div style="display: flex; justify-content: space-between;"><span>Unit:</span> <span>iPhone 11</span></div>
                </div>

                <!-- Info Area (Receipt) -->
                 <div id="receiptInfo" style="display: none; border-bottom: 1px dashed #000; padding-bottom: 5px; margin-bottom: 5px;">
                    <div style="display: flex; justify-content: space-between;"><span>Tgl:</span> <span><?php echo date('d/m/Y H:i'); ?></span></div>
                    <div style="display: flex; justify-content: space-between;"><span>Tiket:</span> <span>SRV-001</span></div>
                    <div style="display: flex; justify-content: space-between;"><span>Cust:</span> <span>Budi Santoso</span></div>
                    <div style="display: flex; justify-content: space-between;"><span>Telp:</span> <span>0812-34xx-xxxx</span></div>
                </div>

                <!-- Invoice Table -->
                <div id="invoiceContent">
                    <table style="width: 100%; border-collapse: collapse; margin-bottom: 5px;">
                        <tr style="border-bottom: 1px solid #000;">
                            <th style="text-align: left;">Item</th>
                            <th style="text-align: right;">Total</th>
                        </tr>
                        <tr>
                            <td>Ganti LCD</td>
                            <td style="text-align: right;">500.000</td>
                        </tr>
                        <tr>
                            <td>Jasa Pasang</td>
                            <td style="text-align: right;">100.000</td>
                        </tr>
                    </table>

                    <div style="border-top: 1px dashed #000; padding-top: 5px;">
                        <div style="display: flex; justify-content: space-between;"><span>Total:</span> <span>600.000</span></div>
                        <div style="display: flex; justify-content: space-between;"><span>DP:</span> <span>- 100.000</span></div>
                        <div style="display: flex; justify-content: space-between; font-weight: bold; font-size: 14px; border-top: 1px solid #000; margin-top: 2px; padding-top: 2px;">
                            <span>Sisa:</span> <span>500.000</span>
                        </div>
                    </div>
                </div>

                <!-- Receipt Details -->
                <div id="receiptContent" style="display: none;">
                    <div style="margin-bottom: 5px;">
                        <p style="margin: 2px 0;"><strong>Unit:</strong> iPhone 11</p>
                        <p style="margin: 2px 0;"><strong>Keluhan:</strong> LCD Pecah</p>
                        <p style="margin: 2px 0;"><strong>Kondisi:</strong> Lecet Pemakaian</p>
                        <p style="margin: 2px 0;"><strong>Kelengkapan:</strong> Unit Only</p>
                    </div>
                    <div style="margin-top: 5px; border-top: 1px dashed #000; padding-top: 5px;">
                        <p style="margin: 2px 0;"><strong>DP Tunai:</strong> Rp 100.000</p>
                    </div>
                </div>

                <div style="text-align: center; margin-top: 15px; font-size: 10px;">
                    <div id="prevFooterNote" style="margin: 0; text-align: center;">Terima kasih atas kepercayaan Anda.</div>
                    <div id="prevReceiptPolicy" style="margin: 0; text-align: left; display: none; white-space: pre-line;"></div>
                    
                    <!-- Signature Placeholder -->
                    <div id="receiptSignature" style="display: none; margin-top: 15px;">
                        <p>( Budi Santoso )</p>
                        <p>Tanda Tangan Customer</p>
                    </div>
                </div>

            </div>
            
            <div class="mt-3 text-center text-muted" style="font-size: 0.8rem;">
                <i class="fas fa-info-circle"></i> Preview otomatis
            </div>
        </div>

    </div>
</form>

<script>
function switchTab(tabName) {
    // Hide all tabs
    document.querySelectorAll('.tab-section').forEach(el => el.classList.remove('active'));
    document.querySelectorAll('.menu-item').forEach(el => el.classList.remove('active'));
    
    // Show selected
    document.getElementById('tab-' + tabName).classList.add('active');
    
    let menuItems = document.querySelectorAll('.menu-item');
    if(tabName === 'general') menuItems[0].classList.add('active');
    if(tabName === 'invoice') menuItems[1].classList.add('active');
    if(tabName === 'receipt') menuItems[2].classList.add('active');

    // Auto switch preview mode
    let previewSelect = document.getElementById('previewMode');
    if(tabName === 'receipt') {
        previewSelect.value = 'receipt';
    } else {
        previewSelect.value = 'invoice';
    }
    updatePreview();
}

function updatePreview() {
    // Get inputs
    let name = document.getElementById('storeNameInput').value;
    let address = document.getElementById('storeAddressInput').value;
    let phone = document.getElementById('storePhoneInput').value;
    
    let footer = document.getElementById('footerNoteInput').value;
    let width = document.getElementById('printerWidthInput').value;
    
    let receiptTitle = document.getElementById('receiptTitleInput').value;
    let receiptPolicy = document.getElementById('receiptPolicyInput').value;
    
    let mode = document.getElementById('previewMode').value;

    // Common
    document.getElementById('prevStoreName').innerText = name;
    document.getElementById('prevStoreAddress').innerText = address;
    document.getElementById('prevStorePhone').innerText = "Telp/WA: " + phone;

    // Width
    let previewBox = document.getElementById('invoicePreview');
    if (width === '58mm') {
        previewBox.style.maxWidth = '58mm';
        previewBox.style.fontSize = '10px'; 
    } else {
        previewBox.style.maxWidth = '80mm';
        previewBox.style.fontSize = '12px';
    }

    // Toggle Content
    if (mode === 'invoice') {
        document.getElementById('invoiceInfo').style.display = 'block';
        document.getElementById('receiptInfo').style.display = 'none';

        document.getElementById('invoiceContent').style.display = 'block';
        document.getElementById('receiptContent').style.display = 'none';
        
        document.getElementById('prevReceiptTitle').style.display = 'none';
        
        document.getElementById('prevFooterNote').style.display = 'block';
        document.getElementById('prevFooterNote').innerText = footer;
        
        document.getElementById('prevReceiptPolicy').style.display = 'none';
        document.getElementById('receiptSignature').style.display = 'none';
    } else {
        document.getElementById('invoiceInfo').style.display = 'none';
        document.getElementById('receiptInfo').style.display = 'block';

        document.getElementById('invoiceContent').style.display = 'none';
        document.getElementById('receiptContent').style.display = 'block';
        
        document.getElementById('prevReceiptTitle').style.display = 'block';
        document.getElementById('prevReceiptTitle').innerText = receiptTitle;

        document.getElementById('prevFooterNote').style.display = 'none';
        
        document.getElementById('prevReceiptPolicy').style.display = 'block';
        document.getElementById('prevReceiptPolicy').innerText = receiptPolicy;
        
        document.getElementById('receiptSignature').style.display = 'block';
    }
}

// Init
window.onload = updatePreview;
</script>

<?php require_once '../../layouts/footer.php'; ?>
