<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM spareparts WHERE id = ?");
$stmt->execute([$id]);
$part = $stmt->fetch();

if (!$part) die("Barang tidak ditemukan.");
?>

<div class="card" style="max-width: 600px; margin: 0 auto;">
    <div class="card-header mb-3">
        <div class="d-flex justify-between align-center">
            <h2 style="margin: 0;">Atur Stok</h2>
            <a href="index.php" class="btn-primary" style="background: #6b7280; font-size: 0.8rem; padding: 0.4rem 0.8rem;">Kembali</a>
        </div>
        <p class="text-muted mt-2" style="margin-bottom: 0;">Barang: <strong><?php echo $part['name']; ?></strong> (Stok: <?php echo $part['stock']; ?>)</p>
    </div>

    <form action="update_stock.php" method="POST">
        <input type="hidden" name="id" value="<?php echo $part['id']; ?>">
        
        <div class="form-group">
            <label>Jenis Penyesuaian</label>
            <select name="type" class="form-control">
                <option value="in">Barang Masuk (+)</option>
                <option value="out">Barang Keluar/Rusak (-)</option>
                <option value="adjustment">Stock Opname (Set Ulang)</option>
            </select>
        </div>

        <div class="form-group">
            <label>Jumlah (Qty)</label>
            <input type="number" name="qty" class="form-control" required min="1">
            <small class="text-muted">Untuk Stock Opname, masukkan jumlah real fisik.</small>
        </div>

        <div class="form-group">
            <label>Keterangan</label>
            <input type="text" name="notes" class="form-control" placeholder="Contoh: Beli dari marketplace / Barang pecah" required>
        </div>

        <button type="submit" class="btn-primary">Simpan</button>
    </form>
</div>

<?php require_once '../../layouts/footer.php'; ?>
