<?php
require_once '../../layouts/header.php';
require_once '../../config/database.php';

$search = $_GET['search'] ?? '';
$query = "SELECT * FROM spareparts WHERE name LIKE ? ORDER BY name ASC";
$stmt = $pdo->prepare($query);
$stmt->execute(["%$search%"]);
$parts = $stmt->fetchAll();
?>

<div class="card">
    <div class="card-header d-flex justify-between align-center flex-wrap gap-4 mb-4">
        <h2 style="margin: 0;">Stok Sparepart</h2>
        <a href="create.php" class="btn-primary">
            <i class="fas fa-plus"></i> Tambah Barang
        </a>
    </div>

    <!-- Summary Stats -->
    <?php
    $stmt = $pdo->query("SELECT COUNT(*) as total_items, SUM(stock * buy_price) as total_asset FROM spareparts");
    $stats = $stmt->fetch();
    ?>
    <div class="grid-2 mb-4">
        <div class="alert alert-info d-flex align-center justify-between" style="background: #eff6ff; border: 1px solid #bfdbfe; color: #1e40af;">
            <div>
                <h4 style="margin: 0; font-size: 1.5rem;"><?php echo $stats['total_items']; ?></h4>
                <small>Total Jenis Barang</small>
            </div>
            <i class="fas fa-boxes" style="font-size: 2rem; opacity: 0.5;"></i>
        </div>
        <div class="alert alert-success d-flex align-center justify-between" style="background: #f0fdf4; border: 1px solid #bbf7d0; color: #166534;">
            <div>
                <h4 style="margin: 0; font-size: 1.5rem;">Rp <?php echo number_format($stats['total_asset'], 0, ',', '.'); ?></h4>
                <small>Total Aset (Modal)</small>
            </div>
            <i class="fas fa-wallet" style="font-size: 2rem; opacity: 0.5;"></i>
        </div>
    </div>

    <form class="mb-4 d-flex flex-wrap gap-2" method="GET">
        <div style="flex: 1; min-width: 200px;">
             <input type="text" name="search" class="form-control" placeholder="Cari Sparepart..." value="<?php echo htmlspecialchars($search); ?>">
        </div>
        <button type="submit" class="btn-primary" style="width: auto;">
            <i class="fas fa-search"></i> Cari
        </button>
        <?php if($search): ?>
            <a href="index.php" class="btn-primary btn-danger" style="width: auto;">Reset</a>
        <?php endif; ?>
    </form>

    <div class="table-responsive">
        <table class="table table-hover">
            <thead>
                <tr>
                    <th>Nama Barang</th>
                    <th>Stok</th>
                    <th>Garansi</th>
                    <th>Harga Beli</th>
                    <th>Stok Cacat</th>
                    <th>Harga Jual</th>
                    <th class="text-center">Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php if (count($parts) > 0): ?>
                    <?php foreach ($parts as $part): ?>
                    <tr>
                        <td><strong><?php echo $part['name']; ?></strong></td>
                        <td>
                            <?php 
                            $badge_class = $part['stock'] < 5 ? 'bg-red-100 text-red-800' : 'bg-green-100 text-green-800';
                            $badge_style = $part['stock'] < 5 ? 'background-color: #fee2e2; color: #991b1b;' : 'background-color: #dcfce7; color: #166534;';
                            ?>
                            <span class="badge" style="<?php echo $badge_style; ?>">
                                <?php echo $part['stock']; ?> Unit
                            </span>
                        </td>
                        <td>
                            <?php if ($part['warranty_days'] > 0): ?>
                                <span class="badge" style="background-color: #e0e7ff; color: #4338ca;">
                                    <i class="fas fa-shield-alt"></i> <?php echo $part['warranty_days']; ?> Hari
                                </span>
                            <?php else: ?>
                                <span class="text-muted">-</span>
                            <?php endif; ?>
                        </td>
                        <td>Rp <?php echo number_format($part['buy_price'], 0, ',', '.'); ?></td>
                        <td>
                            <span class="badge" style="background-color: #fee2e2; color: #991b1b;">
                                <?php echo $part['defect_stock']; ?> Unit
                            </span>
                        </td>
                        <td>Rp <?php echo number_format($part['sell_price'], 0, ',', '.'); ?></td>
                        <td class="text-center">
                            <div class="d-flex justify-center gap-2">
                                <a href="adjust.php?id=<?php echo $part['id']; ?>" class="btn-primary" style="padding: 0.4rem 0.6rem; font-size: 0.8rem; background: var(--primary-color);" title="Tambah Stok">
                                    <i class="fas fa-plus"></i>
                                </a>
                                <a href="edit.php?id=<?php echo $part['id']; ?>" class="btn-primary" style="padding: 0.4rem 0.6rem; font-size: 0.8rem; background: var(--warning-color); border-color: var(--warning-color);" title="Edit">
                                    <i class="fas fa-edit"></i>
                                </a>
                                <a href="history.php?id=<?php echo $part['id']; ?>" class="btn-primary" style="padding: 0.4rem 0.6rem; font-size: 0.8rem; background: #8b5cf6; border-color: #8b5cf6; color: white;" title="Riwayat">
                                    <i class="fas fa-history"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="5" class="text-center py-4 text-muted">Belum ada data sparepart.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once '../../layouts/footer.php'; ?>
