<?php
session_start();
require_once '../../config/database.php';

if ($_SESSION['role'] != 'admin') exit('Akses Ditolak');

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $id = $_POST['id'];
    $name = $_POST['name'];
    $username = $_POST['username'];
    $role = $_POST['role'];
    $password = $_POST['password'];

    try {
        if (!empty($password)) {
            // Update with password
            $hashed_password = password_hash($password, PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("UPDATE users SET name = ?, username = ?, role = ?, password = ? WHERE id = ?");
            $stmt->execute([$name, $username, $role, $hashed_password, $id]);
        } else {
            // Update without password
            $stmt = $pdo->prepare("UPDATE users SET name = ?, username = ?, role = ? WHERE id = ?");
            $stmt->execute([$name, $username, $role, $id]);
        }

        $_SESSION['flash_message'] = "User berhasil diupdate!";
        $_SESSION['flash_type'] = "success";
        header("Location: index.php");
        exit();
    } catch (PDOException $e) {
        die("Error: " . $e->getMessage());
    }
}
?>
